import numpy as np 



def get_center_colors_no_closing(clust_indices,color_flag,num_colors):
    # TAKE_NOTE: Get the colors of the centers for Color-Blind and GF 
    center_colors = [0]*num_colors

    for index in clust_indices:
        color = color_flag[int(index)]
        center_colors[color] = 1 + center_colors[color]  


    return center_colors



def get_center_colors_possible_closing(x,num_clusters,clust_indices,color_flag,num_colors):
	x = np.reshape(x , (-1,num_clusters))  
	cluster_sizes = np.zeros((num_clusters))
	cluster_sizes = x.sum(axis=0)
	center_colors = [0]*num_colors

	for center , index in enumerate(clust_indices):
		if cluster_sizes[center] >0:
			color = color_flag[int(index)]
			center_colors[color] = 1 + center_colors[color]

	return center_colors




def check_if_color_are_covered(sh, centerLowerBound): 
	covered = True 

	num_colors = len(sh)
	for col in range(num_colors): 
		if sh[col] < centerLowerBound[col]: 
			covered = False 

	return not covered


# x is the solution full
# clustIndex is the index of the cluster
# Q is the full dictionary 
def Divide(x,clustIndex,Q): 

	if len(Q[clustIndex])==1:
		pass 
	else: 
		pass 


